## Excel Numerical Functions

A set of Excel like functions supported by icCube (if a parameter is null they will return null)



### Return

```
void
```



### Description

A list of Excel Numerical functions to follow MDX standard.
<UL>
<li><b>ABS</b> , returns the absolute value of the numerical parameter
<li><b>ACOS</b> , returns the arc cosine
<li><b>ACOSH</b> , returns the inverse hyperbolic cosine
<li><b>ASIN</b> , returns the arc sine 
<li><b>ASINH</b> , returns the inverse hyperbolic sine 
<li><b>ATAN</b> , returns the arc tangent 
<li><b>ATANH</b> , returns the inverse hyperbolic tangent 
<li><b>COS</b> , returns the cosine
<li><b>COSH</b> , returns the hyperbolic cosine
<li><b>DEGREES</b> , returns the measurement of the angle parameter in degrees
<li><b>DOLLAR</b> , returns the parameter
<li><b>EXP</b> , returns the exponential (natural base)
<li><b>FACT</b> , returns the factorial (n * (n-1) * (n-2) * ... * 1  , if n = 0 returns 1)
<li><b>INT</b> , returns rounding defined as Math.round(d - 0.5)
<li><b>LN</b> , returns the natural logarithm
<li><b>LOG10</b> , returns the logarithm with base 10
<li><b>RADIANS</b> , returns the angle parameter in radians.
<li><b>SIGN</b> , returns the sign of the parameter value (0,1,-1)
<li><b>SIN</b> , returns the sine
<li><b>SINH</b> , returns the hyperbolic sine
<li><b>SQRT</b> , returns the positive square root
<li><b>TAN</b> , returns the tangent
<li><b>TANH</b> , returns the hyperbolic tangent
<li><b>ATAN2</b> , returns the java equivalent of Math.atan2
<li><b>CEILING(d0,d1)</b> , returns the java equivalent of MathX.ceiling(d0, d1)
<li><b>COMBIN(d0,d1)</b> , returns the java equivalent of MathX.nChooseK(d0,d1)
<li><b>FLOOR(d0,d1)</b> , returns the java equivalent of  MathX.floor(d0, d1)
<li><b>MOD(d0,d1)</b> , returns the remainder resulting from operation: d0 / d1
<li><b>POWER(d0,d1)</b> , returns the value of the first argument raised to the power of the second argument.
<li><b>ROUND(d0,d1)</b> , returns the java equivalent of MathX.round(d0, (int) d1)
<li><b>ROUNDDOWN(d0,d1)</b> , returns the java equivalent of MathX.roundDown(d0, (int) d1)
<li><b>ROUNDUP(d0,d1)</b> , returns the java equivalent of MathX.roundUp(d0, (int) d1)
<li><b>LOG</b> , returns the logarithm of base 10
</UL>



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Rounding functions

</div>

<div class="ic3-mdx-example-body" style="display:none">

Example of different rounding functions

**Query**

```
WITH
  MEMBER [Ceiling(x,1)] AS Ceiling( [Measures].defaultmember,1 )
  MEMBER [Floor(x,1)] AS Floor( [Measures].defaultmember,1 )
  MEMBER [Round(x,0)] AS Round( [Measures].defaultmember,0 )
  MEMBER [RoundDown(x,0)] AS RoundDown( [Measures].defaultmember,0 )
  MEMBER [RoundUp(x,0)] AS RoundUp( [Measures].defaultmember,0 )
  MEMBER [Int(x)] AS Int( [Measures].defaultmember )
  MEMBER [Stats].[Stats-Dim].[-0.45] AS -0.45
  MEMBER [Stats].[Stats-Dim].[-0.50] AS -0.50
  MEMBER [Stats].[Stats-Dim].[-0.55] AS -0.55
  MEMBER [Stats].[Stats-Dim].[0.45] AS 0.45
  MEMBER [Stats].[Stats-Dim].[0.50] AS 0.50
  MEMBER [Stats].[Stats-Dim].[0.55] AS 0.55
  MEMBER [Stats].[Stats-Dim].[1.45] AS 1.45
  MEMBER [Stats].[Stats-Dim].[1.50] AS 1.50
  MEMBER [Stats].[Stats-Dim].[1.55] AS 1.55
  MEMBER [Stats].[Stats-Dim].[2.45] AS 2.45
  MEMBER [Stats].[Stats-Dim].[2.50] AS 2.50
  MEMBER [Stats].[Stats-Dim].[2.55] AS 2.55
SELECT
 {
   [Stats].[Stats-Dim].[-0.55],[Stats].[Stats-Dim].[-0.50],[Stats].[Stats-Dim].[-0.45],
   [Stats].[Stats-Dim].[0.45],[Stats].[Stats-Dim].[0.50],[Stats].[Stats-Dim].[0.55],
   [Stats].[Stats-Dim].[1.45],[Stats].[Stats-Dim].[1.50],[Stats].[Stats-Dim].[1.55],
   [Stats].[Stats-Dim].[2.45],[Stats].[Stats-Dim].[2.50],[Stats].[Stats-Dim].[2.55] } on 0,
 { [Int(x)],[Ceiling(x,1)],[Floor(x,1)],  [Round(x,0)],  [RoundDown(x,0)] ,  [RoundUp(x,0)]  } on 1
 from [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">-0.55</td>
  <td class="ic3-mdx-result-cell-header">-0.50</td>
  <td class="ic3-mdx-result-cell-header">-0.45</td>
  <td class="ic3-mdx-result-cell-header">0.45</td>
  <td class="ic3-mdx-result-cell-header">0.50</td>
  <td class="ic3-mdx-result-cell-header">0.55</td>
  <td class="ic3-mdx-result-cell-header">1.45</td>
  <td class="ic3-mdx-result-cell-header">1.50</td>
  <td class="ic3-mdx-result-cell-header">1.55</td>
  <td class="ic3-mdx-result-cell-header">2.45</td>
  <td class="ic3-mdx-result-cell-header">2.50</td>
  <td class="ic3-mdx-result-cell-header">2.55</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Int(x)</td>
 <td>-1.0</td>
 <td>-1.0</td>
 <td>-1.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>2.0</td>
 <td>2.0</td>
 <td>2.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Ceiling(x,1)</td>
 <td>NaN</td>
 <td>NaN</td>
 <td>NaN</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>2.0</td>
 <td>2.0</td>
 <td>2.0</td>
 <td>3.0</td>
 <td>3.0</td>
 <td>3.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Floor(x,1)</td>
 <td>NaN</td>
 <td>NaN</td>
 <td>NaN</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>2.0</td>
 <td>2.0</td>
 <td>2.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Round(x,0)</td>
 <td>-1.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>2.0</td>
 <td>2.0</td>
 <td>2.0</td>
 <td>3.0</td>
 <td>3.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">RoundDown(x,0)</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>2.0</td>
 <td>2.0</td>
 <td>2.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">RoundUp(x,0)</td>
 <td>-1.0</td>
 <td>-1.0</td>
 <td>-1.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>2.0</td>
 <td>2.0</td>
 <td>2.0</td>
 <td>3.0</td>
 <td>3.0</td>
 <td>3.0</td>
</tr>
</table>



 
</div>

                                                                                                            

### See Also


[Excel Conversion Functions](Excel%20Conversion%20Functions.md)

[Excel Date Functions](Excel%20Date%20Functions.md)

[Excel Text Functions](Excel%20Text%20Functions.md)

[Java Functions](Java%20Functions.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
